%Fig2 left
addpath('rntk/')
param = struct();
param.sigmaw = sqrt(2);
param.sigmau = 1;
param.sigmav = 1;
param.sigmab = 0;
param.L = 1;
param.sigmah = 0;
param.nonlinearity = 1;
x = [1,-1,1];
N = [500,5000];
repeat = 20;
Length = 100;
alpha = 2*pi*(0:Length)/Length;
result = zeros(length(N),length(alpha),repeat);
%%
for i = 1:length(N)
    n = N(i);
    for r = 1:repeat
        weights = struct();
        weights.w = randn(n,n);
        weights.u = randn(n,1);
        weights.b = randn(n,1);
        weights.v = randn(n,1);
        for j = 1:length(alpha)
            xp = [cos(alpha(j)),sin(alpha(j))];
            result(i,j,r)  = empericalrntk_weight_tied(x,xp,param,weights);
            percent = 100*((i-1)*repeat*length(alpha) + (r-1)*length(alpha) + j)/(length(alpha)*length(N)*repeat);
            fprintf('%.2f percent complete \n',percent)
        end
    end
end
%%
anal = zeros(1,length(alpha));
for j = 1:length(alpha)
    xp = [cos(alpha(j)),sin(alpha(j))];
    anal(j) = newRNTK(x,xp,param);
end
plot(alpha,anal)
%%
colors = cell(3,1);
colors{1} = [0, 0.4470, 0.7410];
colors{2} = [0.8500, 0.3250, 0.0980];
plots = cell(length(N),repeat);
for i = 1:length(N)
    for r = 1:repeat
        plots{i,r} = plot(alpha,result(i,:,r),'color',colors{i}, 'Linewidth', 1);
        hold on
    end
end
p = plot(alpha,anal,'color',[0   0   0]/255,'Linewidth',2);
xlim([0 2*pi])
ylim([-0.25 2])
set(gca,'FontSize',20)
LEG = legend([plots{1,1} plots{2,1} p],'$ n = 500 $', '$n = 5000$', '$n = \infty$', 'Interpreter','latex');
LEG.FontSize = 30;
pbaspect([1.6 1 1])

